%% SIR simulation plots

% Plots a comparison of susceptible and infected populations 
% for multiple scenarios
%
% Uses sir_sim.m, 2020/10/26 version
%
% User specifies a list of values for one of the key parameters:
%   R0 is the basic reproductive number
%   T is the mean infectious duration
%   I0 is the initial infectious fraction
%   V is the initial immune fraction
%
% The program is designed so that only two lines need to be modified to
% make a new experiment (see '%%%' comments)
%     line 42 defines the independent variable values
%     line 65 links the independent variable name and values
%
% Output figure:
%   left panel: susceptible fraction
%   center panel: phase portrait
%   right panel: infected fraction
%
% by Glenn Ledder
% written 2020/06/21
% revised 2020/10/26
%
% direct comments to gledder@unl.edu

%% DEFAULT SCENARIO DATA

R0 = 2.5;
T = 5;
I0 = 0.001;
V = 0;

%% INDEPENDENT VARIABLE DATA

%%% This section needs to be modified for each experiment.

%%% xvals is the set of independent variable values
xvals = [5,4,3,2];

%% COMMON DATA

target = 0.001;

%% INITIALIZATION

opengl hardwarebasic;
clf
for k=1:3
    subplot(1,3,k)
    hold on
end

N = length(xvals);

%% COMPUTATION and PLOTS

for n=1:N
    
    %%% The left side of this statement needs to be the independent
    %%% variable for the experiment.
    R0 = xvals(n);

    gamma = 1/T;
    beta = gamma*R0;
    [S,I,~] = sir_sim(beta,gamma,I0,V,target);
    days = length(I)-1;

    subplot(1,3,1)
    plot(0:days,S,'LineWidth',1.7)
    subplot(1,3,2)
    plot(S,I,'LineWidth',1.7)
    subplot(1,3,3)
    plot(0:days,I,'LineWidth',1.7)
end

subplot(1,3,1)
xlabel('days')
ylabel('susceptible')
subplot(1,3,2)
xlabel('susceptible')
ylabel('infected')
subplot(1,3,3)
xlabel('days')
ylabel('infected')
legend('R0=5','R0=4','R0=3','R0=2','Location','Northeast')
